% Craig LaBoda
% Duke University
% This function parses the SR400 text file into a struct containing all
% information about the data collection.
function data = parseSR400(fileName)

% Open the file
fid = fopen(horzcat(fileName,'.txt'));
 
% Parse each line
counterAEdge = fgets(fid);
counterAEdge = counterAEdge(17:end-2);
counterALevel = fgets(fid);
counterALevel = str2num(counterALevel(18:end));
triggerEdge = fgets(fid);
triggerEdge = triggerEdge(15:end-2);
triggerLevel = fgets(fid);
triggerLevel = str2num(triggerLevel(16:end));
triggerCycles = fgets(fid);
triggerCycles = str2num(triggerCycles(17:end));
stepSize = fgets(fid);
stepSize = str2num(stepSize(12:end));
gatePoints = fgets(fid);
gatePoints = str2num(gatePoints(14:end));
gateWidth = fgets(fid);
gateWidth = str2num(gateWidth(13:end));
gateDelay = fgets(fid);
gateDelay = str2num(gateDelay(13:end));
dwellTime = fgets(fid);
dwellTime = str2num(dwellTime(13:end));

dataCell = textscan(fid,'%f %f','Delimiter',',');
timeVec = dataCell{1};
dataVals = dataCell{2};

% Create a struct from the lines
data = struct(  'counterAEdge',counterAEdge,...
                'counterALevel',counterALevel,...
                'triggerEdge',triggerEdge,...
                'triggerLevel',triggerLevel,...
                'triggerCycles',triggerCycles,...
                'stepSize',stepSize,...
                'gatePoints',gatePoints,...
                'gateWidth',gateWidth,...
                'gateDelay',gateDelay,...
                'dwellTime',dwellTime,...
                'timeVec',timeVec,...
                'data',dataVals);
    
fclose(fid);