function varargout = SR400_Gated_Scan(varargin)
% Craig LaBoda
% Duke University
% SR400_GATED_SCAN MATLAB code for SR400_Gated_Scan.fig
%      SR400_GATED_SCAN, by itself, creates a new SR400_GATED_SCAN or raises the existing
%      singleton*.
%
%      H = SR400_GATED_SCAN returns the handle to a new SR400_GATED_SCAN or the handle to
%      the existing singleton*.
%
%      SR400_GATED_SCAN('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in SR400_GATED_SCAN.M with the given input arguments.
%
%      SR400_GATED_SCAN('Property','Value',...) creates a new SR400_GATED_SCAN or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before SR400_Gated_Scan_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to SR400_Gated_Scan_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help SR400_Gated_Scan

% Last Modified by GUIDE v2.5 13-Aug-2014 15:03:19

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @SR400_Gated_Scan_OpeningFcn, ...
                   'gui_OutputFcn',  @SR400_Gated_Scan_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before SR400_Gated_Scan is made visible.
function SR400_Gated_Scan_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to SR400_Gated_Scan (see VARARGIN)

% Get rid of all instruments
delete(instrfindall)

% Establish connection with instrument
% Set up the instrument object
global sr400;
global data;
global saveDir;

sr400 = serial( 'COM1',...
                'BaudRate',9600,...
                'Terminator','CR',...
                'Parity','none',...
                'DataBits',8);

% Connect to instrument
fopen(sr400);
saveDir = pwd;
set(handles.status,'String','Connected to SR400');
set(handles.filePath,'String',saveDir);


% Setup the plot
data = 0;
plot(0,0);
hold off;
set(gca,'fontsize',12)
axis([0 1e-3 0 100])
title('Photons Counted')
xlabel('Time (s)')
ylabel('Photons/bin')

% Set up Email Service
mail = 'address@gmail.com';
password = 'pw';        
setpref('Internet','E_mail',mail);
setpref('Internet','SMTP_Server','smtp.gmail.com');
setpref('Internet','SMTP_Username',mail);
setpref('Internet','SMTP_Password',password);
props = java.lang.System.getProperties;
props.setProperty('mail.smtp.auth','true');
props.setProperty('mail.smtp.socketFactory.class', 'javax.net.ssl.SSLSocketFactory');
props.setProperty('mail.smtp.socketFactory.port','465');

% Choose default command line output for SR400_Gated_Scan
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes SR400_Gated_Scan wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = SR400_Gated_Scan_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on button press in submitSettings.
function submitSettings_Callback(hObject, eventdata, handles)
% hObject    handle to submitSettings (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

global sr400;
global data;

% Update status
set(handles.status,'String','Saved Settings');

% Permanent Settings
% Set counting mode to A for preset T
fprintf(sr400,'CM0');
% Set the front panel output source to A
fprintf(sr400,'AS0');
% Gate mode = scan on gate A
fprintf(sr400,'GM0,2');
% Counter A = input 1
fprintf(sr400,'CI0,1');
% Set T trigger to trig input
fprintf(sr400,'CI2,3');


% Set the number of periods
fprintf(sr400,horzcat('NP',num2str(get(handles.periods,'string'))));
% Set the dwell time
fprintf(sr400,horzcat('DT',num2str(get(handles.dwellTime,'string'))));
% Set gate step size
fprintf(sr400,horzcat('GY0,',num2str(get(handles.steps,'string'))));
% Set the gate delay to 0
fprintf(sr400,horzcat('GD0,',num2str(get(handles.gateDelay,'string'))));
% Set gate Width 
fprintf(sr400,horzcat('GW0,',num2str(get(handles.gateWidth,'string'))));
% Set the trigger level
fprintf(sr400,horzcat('TL',num2str(get(handles.triggerLevel,'string'))));
% Set T trigger's number of cycles
fprintf(sr400,horzcat('CP2,',num2str(get(handles.triggerCycles,'string'))));
% Set discriminator A value
fprintf(sr400,horzcat('DL0,',num2str(get(handles.counterALevel,'string'))));

% Trigger on the correct edges
if (get(handles.triggerEdge,'value')==1)
    fprintf(sr400,'TS1');
else
    fprintf(sr400,'TS0');
end
if (get(handles.counterAEdge,'value')==1)
    fprintf(sr400,'DS0,1');
else
    fprintf(sr400,'DS0,0');
end



% --- Executes on button press in startScan.
function startScan_Callback(hObject, eventdata, handles)
% hObject    handle to startScan (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

global sr400;
global data;

set(handles.status,'String','Currently Scanning');
pause(0.01);

% Set a repeat value
repeat = 1;
stopFlag=0;

while (repeat==1 && stopFlag==0)
    % Set the front panel to the delay
    fprintf(sr400,'MD2,2');
    % Start the scan
    fprintf(sr400,'CR');
    fprintf(sr400,'CS');
    p = str2num(get(handles.periods,'string'));

    % Collect data as available
    dataStatus = '-1';
    scanPos = 1;
    data = zeros(1,p);
    set(handles.stopScan,'UserData',[]);

    % Do this by looping through the periods
    while(scanPos<=p && stopFlag==0)
        
        % On the second scan, record how long it takes
        if (scanPos==2)
            tic;
        end

        % Run a continous loop to check for any available data
        while (str2num(dataStatus)<0)

            % Ask the instrument whether data is available
            fprintf(sr400,horzcat('QA ',num2str(scanPos)));
            dataStatus = fgetl(sr400);
        end

        % Record that data value
        data(scanPos) = str2num(dataStatus);
        dataStatus = '-1';

        pause(0.1)
        stopVal = get(handles.stopScan,'UserData');
        if ~isempty(stopVal) && strcmp(stopVal,'stop')
            stopFlag=1;
        else
            % Calculate time for a single iteration
            if (scanPos==2)
                stepTime = (toc)/60; % in minutes
                timeRemain = (p*stepTime)-2*stepTime;
            end

            if (scanPos>2)
                timeRemain = timeRemain-stepTime;
                if (timeRemain<1)
                    set(handles.status,'String',horzcat('Scanning, Time Remaining: ',num2str(timeRemain*60),' s'));
                else
                    set(handles.status,'String',horzcat('Scanning, Time Remaining: ',num2str(timeRemain),' m'));

                end
            end
        end
        
        % Increment scan position
        scanPos = scanPos+1;
        
    end


    if (stopFlag==0)
        set(handles.status,'String','Scan Finished');
        % //\\//\\//\\//\\//\\//\\// Plot the data \\//\\//\\//\\//\\//\\//

        % Calculate the time vector
        timeVec = [1:str2num(get(handles.periods,'string'))].*...
            str2num(get(handles.steps,'string'));
        plot(timeVec,data,'r')
        title('Photons Counted')
        xlabel('Time (s)')
        ylabel('Photons/bin')
        axis([min(timeVec) max(timeVec) 0 max(data)+100])
    end
    
    % Check whether to notify by email
    notify = get(handles.notify,'Value');
    if(notify)
        email = get(handles.email,'String');
        sendmail(email,'Scan Finished','');
        
    end
    
    
    % Check whether we should repeat
    repeat = get(handles.repeat,'Value');
end






% --- Executes on button press in stopScan.
function stopScan_Callback(hObject, eventdata, handles)
% hObject    handle to stopScan (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

global sr400;
global stopFlag;
global data;

set(handles.stopScan,'UserData','stop');
set(handles.status,'String','Data Cleared');

fprintf(sr400,'CH');
fprintf(sr400,'CR');
stopFlag=0;
data=0;

% Fix the plot
plot(0,0);
axis([0 1e-3 0 100])
title('Photons Counted')
xlabel('Time (s)')
ylabel('Photons/bin')






function periods_Callback(hObject, eventdata, handles)
% hObject    handle to periods (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of periods as text
%        str2double(get(hObject,'String')) returns contents of periods as a double


% --- Executes during object creation, after setting all properties.
function periods_CreateFcn(hObject, eventdata, handles)
% hObject    handle to periods (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function gateWidth_Callback(hObject, eventdata, handles)
% hObject    handle to gateWidth (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of gateWidth as text
%        str2double(get(hObject,'String')) returns contents of gateWidth as a double


% --- Executes during object creation, after setting all properties.
function gateWidth_CreateFcn(hObject, eventdata, handles)
% hObject    handle to gateWidth (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function gateDelay_Callback(hObject, eventdata, handles)
% hObject    handle to gateDelay (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of gateDelay as text
%        str2double(get(hObject,'String')) returns contents of gateDelay as a double


% --- Executes during object creation, after setting all properties.
function gateDelay_CreateFcn(hObject, eventdata, handles)
% hObject    handle to gateDelay (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function dwellTime_Callback(hObject, eventdata, handles)
% hObject    handle to dwellTime (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of dwellTime as text
%        str2double(get(hObject,'String')) returns contents of dwellTime as a double


% --- Executes during object creation, after setting all properties.
function dwellTime_CreateFcn(hObject, eventdata, handles)
% hObject    handle to dwellTime (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function steps_Callback(hObject, eventdata, handles)
% hObject    handle to steps (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of steps as text
%        str2double(get(hObject,'String')) returns contents of steps as a double


% --- Executes during object creation, after setting all properties.
function steps_CreateFcn(hObject, eventdata, handles)
% hObject    handle to steps (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in triggerEdge.
function triggerEdge_Callback(hObject, eventdata, handles)
% hObject    handle to triggerEdge (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns triggerEdge contents as cell array
%        contents{get(hObject,'Value')} returns selected item from triggerEdge


% --- Executes during object creation, after setting all properties.
function triggerEdge_CreateFcn(hObject, eventdata, handles)
% hObject    handle to triggerEdge (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function triggerLevel_Callback(hObject, eventdata, handles)
% hObject    handle to triggerLevel (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of triggerLevel as text
%        str2double(get(hObject,'String')) returns contents of triggerLevel as a double


% --- Executes during object creation, after setting all properties.
function triggerLevel_CreateFcn(hObject, eventdata, handles)
% hObject    handle to triggerLevel (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function triggerCycles_Callback(hObject, eventdata, handles)
% hObject    handle to triggerCycles (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of triggerCycles as text
%        str2double(get(hObject,'String')) returns contents of triggerCycles as a double


% --- Executes during object creation, after setting all properties.
function triggerCycles_CreateFcn(hObject, eventdata, handles)
% hObject    handle to triggerCycles (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in counterAEdge.
function counterAEdge_Callback(hObject, eventdata, handles)
% hObject    handle to counterAEdge (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns counterAEdge contents as cell array
%        contents{get(hObject,'Value')} returns selected item from counterAEdge


% --- Executes during object creation, after setting all properties.
function counterAEdge_CreateFcn(hObject, eventdata, handles)
% hObject    handle to counterAEdge (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function counterALevel_Callback(hObject, eventdata, handles)
% hObject    handle to counterALevel (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of counterALevel as text
%        str2double(get(hObject,'String')) returns contents of counterALevel as a double


% --- Executes during object creation, after setting all properties.
function counterALevel_CreateFcn(hObject, eventdata, handles)
% hObject    handle to counterALevel (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in clearData.
function clearData_Callback(hObject, eventdata, handles)
% hObject    handle to clearData (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in saveData.
function saveData_Callback(hObject, eventdata, handles)
% hObject    handle to saveData (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

global data;
global saveDir;

timeVec = [0:str2num(get(handles.periods,'string'))-1].*...
    str2num(get(handles.steps,'string'));

% Get the data
if (length(data)~=1)
else
    data = zeros(1,length(timeVec));
end

% Use the data and the values stored to put together a cell array
saveDir = get(handles.filePath,'string');
if ~(strcmp(saveDir,''))
    if (saveDir(length(saveDir))=='\')
        fileNameString = horzcat(saveDir,get(handles.fileName,'string'),'.txt');
    else
        fileNameString = horzcat(saveDir,'\',get(handles.fileName,'string'),'.txt');
    end
    
    % Open the text file
    fid = fopen(fileNameString,'wt');
    
    % Write all the parameters line by line
    list = get(handles.counterAEdge,'String');
    fprintf(fid,'Counter A Edge, %s\n',list{get(handles.counterAEdge,'Value')});
    fprintf(fid,'Counter A Level, %1.1e\n',str2num(get(handles.counterALevel,'String')));
    list = get(handles.triggerEdge,'String');
    fprintf(fid,'Trigger Edge, %s\n',list{get(handles.triggerEdge,'Value')});
    fprintf(fid,'Trigger Level, %1.1e\n',str2num(get(handles.triggerLevel,'String')));
    fprintf(fid,'Trigger Cycles, %d\n',str2num(get(handles.triggerCycles,'String')));
    fprintf(fid,'Step Size, %1.1e\n',str2num(get(handles.steps,'String')));
    fprintf(fid,'Gate Points, %d\n',str2num(get(handles.periods,'String')));
    fprintf(fid,'Gate Width, %1.1e\n',str2num(get(handles.gateWidth,'String')));
    fprintf(fid,'Gate Delay, %1.1e\n',str2num(get(handles.gateDelay,'String')));
    fprintf(fid,'Dwell Time, %1.1e\n\n',str2num(get(handles.dwellTime,'String')));
    
    % Print the data
    for k=1:length(data)
        fprintf(fid,'%f,%f\n',timeVec(k),data(k));
    end
    
    % Close the file
    fclose(fid);
    
    % Update
    set(handles.status,'String','Data Saved');
    
end


% --- Executes when user attempts to close figure1.
function figure1_CloseRequestFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

global sr400;

% Disconnect from instrument 
fclose(sr400);

% Delete the sr400 object
delete(sr400);

% Hint: delete(hObject) closes the figure
delete(hObject);



function fileName_Callback(hObject, eventdata, handles)
% hObject    handle to fileName (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of fileName as text
%        str2double(get(hObject,'String')) returns contents of fileName as a double


% --- Executes during object creation, after setting all properties.
function fileName_CreateFcn(hObject, eventdata, handles)
% hObject    handle to fileName (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function status_Callback(hObject, eventdata, handles)
% hObject    handle to status (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of status as text
%        str2double(get(hObject,'String')) returns contents of status as a double


% --- Executes during object creation, after setting all properties.
function status_CreateFcn(hObject, eventdata, handles)
% hObject    handle to status (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over stopScan.
function stopScan_ButtonDownFcn(hObject, eventdata, handles)
% hObject    handle to stopScan (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on key press with focus on stopScan and none of its controls.
function stopScan_KeyPressFcn(hObject, eventdata, handles)
% hObject    handle to stopScan (see GCBO)
% eventdata  structure with the following fields (see UICONTROL)
%	Key: name of the key that was pressed, in lower case
%	Character: character interpretation of the key(s) that was pressed
%	Modifier: name(s) of the modifier key(s) (i.e., control, shift) pressed
% handles    structure with handles and user data (see GUIDATA)



function filePath_Callback(hObject, eventdata, handles)
% hObject    handle to filePath (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of filePath as text
%        str2double(get(hObject,'String')) returns contents of filePath as a double


% --- Executes during object creation, after setting all properties.
function filePath_CreateFcn(hObject, eventdata, handles)
% hObject    handle to filePath (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in setPath.
function setPath_Callback(hObject, eventdata, handles)
% hObject    handle to setPath (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

global saveDir;

temp = saveDir;
saveDir = uigetdir(saveDir);
if (saveDir==0)
    saveDir = temp;
end
set(handles.filePath,'String',saveDir);


% --- Executes on button press in repeat.
function repeat_Callback(hObject, eventdata, handles)
% hObject    handle to repeat (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of repeat



function email_Callback(hObject, eventdata, handles)
% hObject    handle to email (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of email as text
%        str2double(get(hObject,'String')) returns contents of email as a double


% --- Executes during object creation, after setting all properties.
function email_CreateFcn(hObject, eventdata, handles)
% hObject    handle to email (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in notify.
function notify_Callback(hObject, eventdata, handles)
% hObject    handle to notify (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of notify
